//=============================================================================
// WeaponRPG, for cars.
//=============================================================================
class DrivableWeaponRepeater extends DrivableWeapon;

function Tick(Float DeltaTime) //special case for repeaters, since they fuck up their own offset
{
 local rotator FinalRot;
 local vector FinalLoc;

 if (AttachedTo != None)
 {
  if (AttachedTo.LeftGun == Self)
  {
   FinalRot = AttachmentRotation + AttachedTo.LeftGunRot;
   FinalRot.Yaw = AttachedTo.Rotation.Yaw;
   SetRotation(FinalRot);
   FinalLoc = AttachedTo.Location + (AttachedTo.LeftGunPos >> Rotation) - vect(0,0,24);
   SetLocation(FinalLoc);
  }
  else if (AttachedTo.RightGun == Self)
  {
   FinalRot = AttachmentRotation + AttachedTo.RightGunRot;
   FinalRot.Yaw = AttachedTo.Rotation.Yaw;
   SetRotation(FinalRot);
   FinalLoc = AttachedTo.Location + (AttachedTo.RightGunPos >> Rotation) - vect(0,0,24);
   SetLocation(FinalLoc);
  }
 }
 if (FlashTimer > 0)
 {
  Multiskins[FlashMultiskin] = MuzzleTexture;
  FlashTimer -= DeltaTime;
 }
 if (FlashTimer <= 0)
 {
  Multiskins[FlashMultiskin] = Default.Multiskins[FlashMultiSkin];
 }
 if (FiringDelay > 0)
  FiringDelay -= DeltaTime;
}

defaultproperties
{
 Mesh=LodMesh'DeusExDeco.AutoTurretGun'
 CollisionHeight=15.000000
 CollisionRadius=15.000000
 MaxAmmo=600
 AmmoLeft=600
 GunName="Repeater"
 ShotTime=0.750000
 NumberOfShots=6
 ProjectileClass=class'MSDriving1_2.BluePellet'
 FiringSound=Sound'DeusExSounds.Weapons.PistolFire'
 CurrentAccuracy=0.720000
 MinProjSpreadAcc=0.720000
 bHasMuzzleFlash=True
 MuzzleTexture=FireTexture'Effects.Electricity.BioCell_SFX'
 FlashMultiSkin=2
}
